def update_bad_positions(bad_positions, p, i, j, n):
    for idx in {i - 1, i, j - 1, j}:
        if 0 <= idx < n - 1:
            if p[idx] > p[idx + 1]:
                bad_positions.add(idx)
            else:
                bad_positions.discard(idx)

def main():
    import sys
    input = sys.stdin.read
    data = input().split()

    n, q = map(int, data[:2])
    p = list(map(int, data[2:2 + n]))
    queries = [tuple(map(lambda x: int(x) - 1, data[2 + n + i * 2:4 + n + i * 2])) for i in range(q)]

    bad_positions = {i for i in range(n - 1) if p[i] > p[i + 1]}
    print(len(bad_positions))

    for i, j in queries:
        update_bad_positions(bad_positions, p, i, j, n)
        p[i], p[j] = p[j], p[i]
        update_bad_positions(bad_positions, p, i, j, n)
        print(len(bad_positions))

if __name__ == "__main__":
    main()